package gov.va.vinci.dart.json;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="ParticipantDocument", propOrder={
		"id",
		"participantName",
		"uploaded",
		"documents"
		})
public class RequestParticipantDocumentView implements Comparable {
	private String participantName;
	
	private String id;	//for group-based documents: need a different ID to key off of (need something unique for each group and each participant)

	private boolean uploaded = false;

	@XmlElement(name="Document")
	private List<DocumentView> documents = new ArrayList<DocumentView>();
	
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getParticipantName() {
		return participantName;
	}

	public void setParticipantName(String participantName) {
		this.participantName = participantName;
	}
	
	public List<DocumentView> getDocuments() {
		return documents;
	}

	public boolean isUploaded() {
		return uploaded;
	}

	public void setUploaded(boolean uploaded) {
		this.uploaded = uploaded;
	}
	
	
	/**
	 * Sort based on the participantName (principal investigator first)
	 */
	@Override
	public int compareTo(Object o) {
		if (o == null) {
			return -1;
		}
		
		if( participantName == null ) {
			return -1;
		}
		if( participantName != null && participantName.contains("Principal Investigator")) {	//principal investigator first
			return -1;
		}

		return participantName.compareTo(((RequestParticipantDocumentView)o).participantName);
	}
	
}

